unit Unit1;

interface

uses
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    Db, DBTables, Grids, DBGrids, ExtCtrls, DBCtrls, StdCtrls, ExDBGrid;

type
    TForm1 = class(TForm)
        DBNavigator1: TDBNavigator;
        Table1: TTable;
        DataSource1: TDataSource;
        Panel1: TPanel;
        CheckBox1: TCheckBox;
        CheckBox2: TCheckBox;
        CheckBox3: TCheckBox;
        CheckBox4: TCheckBox;
        CheckBox5: TCheckBox;
        Button1: TButton;
        Button2: TButton;
        Button3: TButton;
        Button4: TButton;
        Button5: TButton;
        ExDBGrid1: TExDBGrid;
        procedure CheckBox1Click(Sender: TObject);
        procedure CheckBox2Click(Sender: TObject);
        procedure CheckBox3Click(Sender: TObject);
        procedure CheckBox4Click(Sender: TObject);
        procedure CheckBox5Click(Sender: TObject);
        procedure Button1Click(Sender: TObject);
        procedure Button2Click(Sender: TObject);
        procedure Button3Click(Sender: TObject);
        procedure ExDBGrid1ApplyCellAttribute(Sender: TObject; Field: TField;
            Canvas: TCanvas; State: TGridDrawState);
        procedure FormCreate(Sender: TObject);
        procedure Button4Click(Sender: TObject);
        procedure Button5Click(Sender: TObject);
    private
        { Private declarations }
    public
        { Public declarations }
    end;

var
    Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    ExDBGrid1.Perform(wm_Paint, 0, 0);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
    ExDBGrid1.DisplayBoolean := not ExDBGrid1.DisplayBoolean;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
    ExDBGrid1.DisplayImages := not ExDBGrid1.DisplayImages;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
    ExDBGrid1.DisplayMemo := not ExDBGrid1.DisplayMemo;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
    ExDBGrid1.RowSizingAllowed := not ExDBGrid1.RowSizingAllowed;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
    ExDBGrid1.DefaultDrawing := not ExDBGrid1.DefaultDrawing;

    ExDBGrid1.DisplayBoolean := not ExDBGrid1.DisplayBoolean;
    ExDBGrid1.DisplayImages := not ExDBGrid1.DisplayImages;
    ExDBGrid1.DisplayMemo := not ExDBGrid1.DisplayMemo;
    ExDBGrid1.DisplayBoolean := not ExDBGrid1.DisplayBoolean;
    ExDBGrid1.DisplayImages := not ExDBGrid1.DisplayImages;
    ExDBGrid1.DisplayMemo := not ExDBGrid1.DisplayMemo;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    if Button1.Caption = 'Autosize Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoSize := True;
            Table1.EnableControls;
            Button1.Caption := 'Autosize On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoSize := False;
            Table1.EnableControls;
            Button1.Caption := 'Autosize Off'
        end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    if Button2.Caption = 'FullSizeMemo Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.FullSizeMemo := True;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.FullSizeMemo := False;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo Off'
        end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    if Button3.Caption = 'FlatStyle On' then
        begin
            Table1.DisableControls;
            ExDBGrid1.Cells3D := True;
            Table1.EnableControls;
            Button3.Caption := 'Cells3D On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.Cells3D := False;
            Table1.EnableControls;
            Button3.Caption := 'FlatStyle On'
        end;
end;

procedure TForm1.ExDBGrid1ApplyCellAttribute(Sender: TObject;
    Field: TField; Canvas: TCanvas; State: TGridDrawState);
begin
    if Field = Table1.Fields[0] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clBlue;

    if Field = Table1.Fields[1] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clRed;

    if Field = Table1.Fields[2] then
        Canvas.Font.Style := Canvas.Font.Style + [fsBold];

    if Field = Table1.Fields[3] then
        if not (gdSelected in State) then
            Canvas.Brush.Color := clGreen;

    if Field = Table1.Fields[4] then
        if Table1.Fields[4].AsInteger > 30 then
            if not (gdSelected in State) then
                Canvas.Font.Color := clYellow;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    if Button4.Caption = 'AutoWidth Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.Align := alNone;
            ExDBGrid1.Width := ExDBGrid1.OptWidth;
            Table1.EnableControls;
            Button4.Caption := 'AutoWidth On';
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.Align := alClient;
            Table1.EnableControls;
            Button4.Caption := 'AutoWidth Off';
        end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
    if Button5.Caption = 'CellHints Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.CellHints := True;
            Table1.EnableControls;
            Button5.Caption := 'CellHints On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.CellHints := False;
            Table1.EnableControls;
            Button5.Caption := 'CellHints Off'
        end;
end;

end.

